/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.internal.core.inferencing;

import com.aptana.core.IFilter;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.IConfigurationElementProcessor;
import com.aptana.js.core.JSCorePlugin;
import com.aptana.js.core.inferencing.IAliasResolver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AliasResolverFactory
implements IAliasResolver {
    private final String EXTENSION_POINT = "aliasResolver";
    private final String ELEMENT_CONTRIBUTOR = "resolver";
    private final String ELEMENT_PRIORITY = "priority";
    private final String ELEMENT_CLASS = "class";
    private List<ResolverProxy> fProxies = null;

    private synchronized List<ResolverProxy> getResolverProxies() {
        if (this.fProxies == null) {
            this.fProxies = new ArrayList<ResolverProxy>();
            EclipseUtil.processConfigurationElements((String)"com.aptana.js.core", (String)"aliasResolver", (IConfigurationElementProcessor)new IConfigurationElementProcessor(){

                public void processElement(IConfigurationElement element) {
                    AliasResolverFactory.this.fProxies.add(new ResolverProxy(element));
                }

                public Set<String> getSupportElementNames() {
                    return CollectionsUtil.newSet((Object[])new String[]{"resolver"});
                }
            });
            Collections.sort(this.fProxies);
        }
        return this.fProxies;
    }

    @Override
    public String resolve(String sourceType, IPath editorPath, IPath projectPath) {
        List proxies = CollectionsUtil.filter(this.getResolverProxies(), (IFilter)new IFilter<ResolverProxy>(){

            public boolean include(ResolverProxy item) {
                return item != null;
            }
        });
        for (ResolverProxy resolverProxy : proxies) {
            try {
                IAliasResolver resolver = resolverProxy.getResolver();
                String destinationType = resolver.resolve(sourceType, editorPath, projectPath);
                if (destinationType == null) continue;
                return destinationType;
            }
            catch (CoreException e) {
                IdeLog.logWarning((Plugin)JSCorePlugin.getDefault(), (Throwable)e);
            }
            catch (Exception e) {
                IdeLog.logWarning((Plugin)JSCorePlugin.getDefault(), (Throwable)e);
            }
        }
        return sourceType;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ResolverProxy
    implements Comparable<ResolverProxy> {
        private IConfigurationElement ice;
        private int priority;
        private IAliasResolver resolver;

        ResolverProxy(IConfigurationElement ice) {
            this.ice = ice;
            this.priority = -1;
        }

        IAliasResolver getResolver() throws CoreException {
            if (this.resolver == null) {
                this.resolver = (IAliasResolver)this.ice.createExecutableExtension("class");
            }
            return this.resolver;
        }

        synchronized int getPriority() {
            if (this.priority == -1) {
                try {
                    String pri = this.ice.getAttribute("priority");
                    this.priority = Integer.parseInt(pri);
                }
                catch (Exception e) {
                    this.priority = 50;
                }
            }
            return this.priority;
        }

        @Override
        public int compareTo(ResolverProxy o) {
            int thisVal = this.getPriority();
            int anotherVal = o.getPriority();
            return anotherVal - thisVal;
        }
    }
}

